function []=STM32F103_GET_PLOT_V4_0(skt,nbins,Spawn)
%function []=STM32F103_GET_PLOT_V4_0(skt,nbins,dummy)
%  Ian Stothers for DeIce inc
% Dec 12th 2022 to Jul 27th 2023
% Adding stuff to support micro dft
% Dec 20th Ian Stothers
% Fix for curtis noticed bug - atten was evaluated outside of the aquisition loop
%  Dec 21st Ian Stothers - added ip to graph title bars
% Feb 15th-22nd 2023 added temperature input to screen - not very accurate
% May 8-10th 2023 - Mod to improve interaction with dftest_RES
% Re-ordering calibration to make more orthogonal
% June 20th 2023 - Ian Stothers
% Fixed issue with tfsc use
% Added Zero Ph button
% Reordered tfsc and tfoc buttons to refecl use order
% Added voltage and current calibration with settable resistance for cal

% order should be
% Enter Part Number and press PartNo Button - if you want to set it
% Enter Serial Number and press SerNo Button - if you want to set it
%
% if using calibrated load - enter its impedance in set res real/imag and press set res
%
% if using calibrated real load - enter its impedance in set res real and press set res real
%
% if using calibrated imag load - enter its impedance in set res imag and press set res imag
%
% Open Circuit load
% wait 10-20 secs - until imp average settles
% press Set tfoc
%
% Short circuit load
% wait 10-20 secs - until imp average settles
% press Set tfsc
%
% Connect Resistive (50 ohm load nom)
% wait 10-20 secs - until imp average settles
%
% press Zero Ph
%
% If doing Voltage cal with calibrated resistance
%  Type in measured rms voltage into voltage window and press set voltage
%  Current cal is automatically set as well as voltage cal
%
% If doing Current cal with calibrated resistance
%  Type in measured rms current into current window and press set current
%  Voltage cal is automatically set as well as current cal
%
% If doing Current cal without calibrated resistance
%  Note the resistance should be set to 0 ohms to tell the software not to use it
%  Type in measured rms voltage into voltage window and press set voltage
%  Type in measured rms current into current window and press set current
%
%
%
% press save config - to push results into microcontroller RAM and flash

% sort out parameters
 nharm=5;
 if(exist('skt')==0)    skt='192.168.1.4';  endif
 if(exist('nbins')==0)   nbins=2048; endif

 if(exist('Spawn')==0)
  if (ischar(skt)==0)
   skt=skt.ip;
  endif

  %STM32F103_GET_PLOT_V4_0(skt,nbins,dummy)
  callstr1= ["STM32F103_GET_PLOT_V4_0("...
  sprintf("\'%s\',",skt)...
  sprintf("%d,",nbins)...
  sprintf("%d);",1)...
  ];
  octave_spawn(callstr1);
  return
 else
  if (ischar(skt))
   skt=sktopen(skt);
  endif
 endif



  noplot=0;

  udpset(skt,'DoTheDFT',0);
  if (exist('butter')==0)
   pkg load signal;
  end
  BuildName=udpget(skt,"BuildName");
  BuildName=BuildName(find(BuildName>0));
  BuildTimeStamp=udpget(skt,"BuildTimeStamp");
  BuildTimeStamp=BuildTimeStamp(find(BuildTimeStamp>0));


%%Calibration Bits%%%
% Calibration initial match for rload only
  Vcal= 1*exp(-7*i*pi/180); % Compensate for phase angle into voltage input vs current with resistive load
  Ical= 1;      % Note the 1 in Vcal and Ical can be used to change non frequency sensitive gain issues - or use ADC_Scale
  ADC_Scale = [248.34 0; 0 24];  % from Arlie
  Radc=1000;   % For calcullation of atten
  Cadc=11e-12; % For calcullation of atten
%% end of calibration bits

  Vtemp=0;
  SRATE_MAX=875000;

  if (size(findname(skt.name,"ADC_Scale"))>0)
   ADC_Scale=udpget(skt,'ADC_Scale');
  endif
  if (size(findname(skt.name,"Vcal"))>0)
   Vcal=udpget(skt,'Vcal')*[1 ; i];
  endif
  if (size(findname(skt.name,"Ical"))>0)
   Ical=udpget(skt,'Ical')*[1 ; i];
  endif
  if (size(findname(skt.name,"ADC_RC"))>0)
   ADC_RC=udpget(skt,'ADC_RC');
  else
   ADC_RC=Radc*Cadc;
  endif

  %tfoc=exp(i*pi*113/180)/365;  % open circuit output impedance - measured by setting lod open and tfoc=0;
  if (size(findname(skt.name,"tfoc"))>0)
   tfocs=udpget(skt,'tfoc');
   tfoc=tfocs(1)+i*tfocs(2);
  else
   tfoc=0;
  endif
  if (size(findname(skt.name,"tfsc"))>0)
   tfscs=udpget(skt,'tfsc');
   tfsc=tfscs(1)+i*tfscs(2);
  else
   tfsc=0;
  endif
  PartSerno=udpget(skt,'PartSerno');
  n=nbins;
  win=flattopwin(n);
  win=sqrt(2)*win/(sum(win));
  win=win*ones(1,2);

  SRate=STM32F103_ADC_SETUP(skt,[1;0],6750000/8); % make 1st channel volts 2nd current
  STM32F103_CC_SETUP_B3(skt);
  Tvec=(1:nbins)/SRate;
  udpset(skt,'DoTheDFT',0);
  f=STM32F103_CC_GET(skt);
  oldf=zeros(5,1);
  oldf(2:5)=oldf(1:4);
  oldf(1)=f;
  setenv('XDG_SESSION_TYPE','x11');

  if (size(findname(skt.name,"ADC_SR"))>0)
   udpset(skt,'ADC_SR',SRate);
  endif
  harmhand=zeros(1,nharm);
  getno=0;

  Imp_Filt=0.1;
  Imp_Ave_sxy=0.0;
  Imp_Ave_sxx=0.0;
  Imp_Ave=0.0;
  Pow_Ave=0.0;
  Raw_Imp_Ave_sxy=0.0;
  Raw_Imp_Ave_sxx=0.0;
  Raw_Imp_Ave=0.0;
  Raw_Pow_Ave=0.0;
  try
  while (1)
   f=STM32F103_CC_GET(skt);
    if (f<1e6)
      f=median(oldf);
    else
      oldf(2:5)=oldf(1:4);
      oldf(1)=f;
    endif
    atten=abs(1/(1+i*f*2*pi*ADC_RC)); % Compensate for rc input in STM32ADC
    bin=floor(0.5+((f/SRate)-floor(f/SRate))*nbins)+1;
    if (bin>nbins) bin=nbins; endif
    dat=STM32F103_ADC_PLOT(skt,nbins,-1)';

    %    dat=dat(:,2:-1:1);
    md=ones(nbins,1)*mean(dat);
    Vref_Scale=1.5/mean(mean(dat));
    data=(dat-md)*Vref_Scale;

% Set up to read temp sensor
    tmpsqr3=udpget(skt,"ADC1_SQR3");
    udpset(skt,"ADC1_SQR3",16);
    pause(0.001);


%read temp sensor
    tdat=udpget(skt,"ADC1_DR");



%Set multiplexor back to preset value

    udpset(skt,"ADC1_SQR3",tmpsqr3);
    tvolts=[floor(tdat/2^16)  bitand(tdat,65535)  ](2)*3.3/65536;
    temper=((1.50-tvolts)/0.0043)+25; %1.50 and 0.0043 are approx from stm32 datasheet

%    data=sin(bin*2*pi*(1:nbins)/nbins)'*ones(1,2);
    df=fft(data.*win);
    dfraw=df;
    dftmp=df(:,2)-tfoc*df(:,1);
    df(:,1)=df(:,1)-tfsc*df(:,2);
    df(:,2)=dftmp;
    df(:,1)=df(:,1)*Vcal;
    df(:,2)=df(:,2)*Ical;
    df=df*ADC_Scale/atten;


    if ((bin>3)&&(bin<(nbins-2)))
    [dbin,didx]=max(abs(df(bin-1:(bin+1))));
    bin=bin+didx-2;
    endif
% Impedance filter
    Imp_Ave_sxy=((1-Imp_Filt)*Imp_Ave_sxy)+(Imp_Filt*(df(bin,1)*conj(df(bin,2))));
    Imp_Ave_sxx=((1-Imp_Filt)*Imp_Ave_sxx)+(Imp_Filt*(df(bin,2)*conj(df(bin,2))));
    Imp_Ave=Imp_Ave_sxy/Imp_Ave_sxx;
    Pow_Ave=Imp_Ave_sxy;

    Raw_Imp_Ave_sxy=((1-Imp_Filt)*Raw_Imp_Ave_sxy)+(Imp_Filt*(dfraw(bin,1)*conj(dfraw(bin,2))));
    Raw_Imp_Ave_sxx=((1-Imp_Filt)*Raw_Imp_Ave_sxx)+(Imp_Filt*(dfraw(bin,2)*conj(dfraw(bin,2))));
    Raw_Imp_Ave=Raw_Imp_Ave_sxy/Raw_Imp_Ave_sxx;
    Raw_Pow_Ave=Raw_Imp_Ave_sxy;


    res=[sprintf("Freqency=%2.4f MHz",f/1e6)
    sprintf("Impedance=%4.3f Ohms  %4.1f Degrees",abs(df(bin,1)/df(bin,2)),(180/pi)*angle(df(bin,1)/df(bin,2)))
    sprintf("Impedance Average=%4.3f Ohms  %4.1f Degrees",abs(Imp_Ave),(180/pi)*angle(Imp_Ave))
    sprintf("Power    Real=%4.3f  Imag=%4.3f  W",real(df(bin,1)*df(bin,2)'),imag(df(bin,1)*df(bin,2)'))
    sprintf("Power Average   Real=%4.3f  Imag=%4.3f  W",real(Pow_Ave),imag(Pow_Ave))
    sprintf("Voltage = %4.3f Vrms",abs(df(bin,1)))
    sprintf("Current = %4.3f Irms",abs(df(bin,2)))
    sprintf("Temp Sens Volts = %4.3f Volts",tvolts)
    sprintf("Temperature  = %4.3f Deg C",temper)
    sprintf("Part No.:%d  Serial  No.:%d",PartSerno(1),PartSerno(2))
    sprintf("BuildName:%s",BuildName)
    sprintf("BuildTimeStamp:%s",BuildTimeStamp)];

    if (getno<0.5)
     getno=1;


     f1=figure(1);
     clf
     subplot(1,2,2);
     set(f1,"numbertitle","off");
     set(f1,'name',['STM32F103_GET_PLOT IP - ' skt.ip]);
     pdata=data*ADC_Scale/atten;
     plot(Tvec,pdata');
     f1tit=title(res);


     grid on;
     f1=figure(1);
     f1c=get(f1,'children');
     axis([0 nbins/SRate -150 150]);
     f1cc=get(f1c,'children');
     legend(['Volts';'Amps ']);

     LoadRes=50;

     xlabel(['Seconds      ' sprintf('Sample Rate = %6.1f',SRate)]   );
     ylabel('Volts');
     pb1=stopbut(f1,[15  45 100 22],"Set tfsc");
     pb2=stopbut(f1,[15  15 100 22],"Set tfoc");
     pb3=stopbut(f1,[15  330 100 22],"Save Config");
     pb4=stopbut(f1,[15  75 100 22],"Zero Ph");
     pb5=stopbut(f1,[15  135 100 22],"Set Vrms");
     pb6=stopbut(f1,[15  165 100 22],"Set Irms");
     pb7=stopbut(f1,[15  225 100 22],"Set Res Re");
     pb8=stopbut(f1,[15  195 100 22],"Set Res Im");
     pb9=stopbut(f1,[15  255 100 22],"Set Part No.");
     pb10=stopbut(f1,[15  285 100 22],"Set Serial No.");

     eb5=editbox(f1,[140  135 100 22],   sprintf("%4.3f",abs(df(bin,1))));
     eb6=editbox(f1,[140  165 100 22],   sprintf("%4.3f",abs(df(bin,2))));
     eb7=editbox(f1,[140  225 100 22],   sprintf("%4.3f",real(LoadRes)));
     eb8=editbox(f1,[140  195 100 22],   sprintf("%4.3f",imag(LoadRes)));
     eb9=editbox(f1,[140  255 100 22],   sprintf("%4u",PartSerno(1)));
     eb10=editbox(f1,[140  285 100 22],   sprintf("%4u",PartSerno(2)));



     f2=figure(2);
     set(f2,"numbertitle","off");
     set(f2,'name',['STM32F103_GET_PLOT - ' skt.ip]);
     clf;
     hold off;
     plot(20*log10(abs(df(2:(nbins),:))))
     axis([1 nbins -50 70]);
     grid on;
     ylabel('dB re 1 volt or 1 amp');
     xlabel('Frequency bin')
     f2c=get(f2,'children');
     f2cc=get(f2c,'children');
     t2=title(sprintf('Frequency = %fMHz',f/1e6));
     hold on

     for k=1:nharm
        bint=floor(0.5+(((f*k)/SRate)-floor((f*k)/SRate))*nbins)+1;
        if (bint>nbins)
          bint=nbins;
        endif
        harmhand(k)=text(bint,70-(3*k),sprintf("%df",k));
     end
     legend(['Volts';'Amps ']);



     commandwindow
    else


     pdata=data*ADC_Scale/atten;
     set(f1cc(2),'ydata',pdata(:,1)');
     set(f1cc(1),'ydata',pdata(:,2)');

     set(f1tit,'string',res);

      hold off

      set(f2cc(2),'ydata',20*log10(abs(df(2:nbins,1)))');
      set(f2cc(1),'ydata',20*log10(abs(df(2:nbins,2)))');
      set(t2,'string',sprintf('Frequency = %fMHz  Bin - %d',f/1e6,bin));

      hold on
      for k=1:nharm
        bint=floor(0.5+(((f*k)/SRate)-floor((f*k)/SRate))*nbins)+1;
        if (bint>nbins)
          bint=nbins;
        endif
        set(harmhand(k),'position',[bint get(harmhand(k),'position')(2) 0]);
      end
     endif

     if(get(pb1,"value")==1)
      tfsc=Raw_Imp_Ave;
      set(pb1,"value",0);
     endif

     if(get(pb2,"value")==1)
      tfoc=1/Raw_Imp_Ave;
      set(pb2,"value",0);
     endif

     if(get(pb3,"value")==1)
      udpset(skt,'tfoc',[real(tfoc) imag(tfoc)]);
      udpset(skt,'tfsc',[real(tfsc) imag(tfsc)]);
      udpset(skt,'Vcal',[real(Vcal) imag(Vcal)]);
      udpset(skt,'ADC_Scale',ADC_Scale);
      udpset(skt,'PartSerno',PartSerno);
      udpprogconfig(skt);
      set(pb3,"value",0);
     endif

    if(get(pb4,"value")==1)
      erang=(180/pi)*angle(Imp_Ave);
      Vcal=Vcal*exp(-i*erang*pi/180);
      set(pb4,"value",0);
     endif


    if(get(pb5,"value")==1)
     st=get(eb5,"string");
     val5=sscanf(st,'%f');
     set(eb5,"string",sprintf('%4.3f',val5));
     set(pb5,"value",0);
     ADC_Scale(1,1)=    ADC_Scale(1,1)*val5/abs(df(bin,1));
     if (abs(LoadRes)>0)
      set(eb6,"string",sprintf('%4.3f',abs(val5/LoadRes)));
      ADC_Scale(2,2)=    ADC_Scale(2,2)*(val5/LoadRes)/abs(df(bin,2));
     endif
    endif

    if(get(pb6,"value")==1)
     st=get(eb6,"string");
     val6=sscanf(st,'%f');
     set(eb6,"string",sprintf('%4.3f',val6));
       set(pb6,"value",0);
     ADC_Scale(2,2)=    ADC_Scale(2,2)*(val6/abs(df(bin,2)));
     if (abs(LoadRes)>0)
      set(eb5,"string",sprintf('%4.3f',abs(val6*LoadRes)));
      ADC_Scale(1,1)=    ADC_Scale(1,1)*LoadRes*val6/abs(df(bin,1));
     endif
    endif


   if(get(pb7,"value")==1)
     st=get(eb7,"string");
     val7=sscanf(st,'%f');
     set(eb7,"string",sprintf('%4.3f',val7));
     set(pb7,"value",0);
     LoadRes = val7+ imag(LoadRes);
   endif

   if(get(pb8,"value")==1)
     st=get(eb8,"string");
     val8=sscanf(st,'%f');
     set(eb8,"string",sprintf('%4.3f',val8));
     set(pb8,"value",0);
     LoadRes = i*val8+ real(LoadRes);
   endif

   if(get(pb9,"value")==1)
     st=get(eb9,"string");
     val9=sscanf(st,'%u');
     set(eb9,"string",sprintf('%u',val9));
     set(pb9,"value",0);
     PartSerno(1) = val9;
   endif

   if(get(pb10,"value")==1)
     st=get(eb10,"string");
     val10=sscanf(st,'%u');
     set(eb10,"string",sprintf('%u',val10));
     set(pb10,"value",0);
     PartSerno(2) = val10;
   endif


   pause(0.05)
  endwhile
  catch
  %cleanup
   udpset(skt,'DoTheDFT',1);
   if(isfigure(f1)==1) delete(f1); end
   if(isfigure(f2)==1) delete(f2); end
   return;
  end
endfunction



function [pb]=stopbut(f,pos,txt)
% Create an pushbutton control
 pb=uicontrol(...
 f,"style","togglebutton",...
 "string",txt,...
 "position",pos);
endfunction

function [eb]=editbox(f,pos,txt)
% Create an edit control
 eb = uicontrol (...
 f, "style", "edit",...
 "string", txt, ...
 "position",pos);
endfunction
